/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.tree.AbstractInsnNode;
import scala.tools.asm.tree.LabelNode;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode dflt, int[] keys, LabelNode[] labels2) {
        super(171);
        this.dflt = dflt;
        this.keys = new ArrayList<Integer>(keys == null ? 0 : keys.length);
        this.labels = new ArrayList<LabelNode>(labels2 == null ? 0 : labels2.length);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this.keys.add(new Integer(keys[i]));
            }
        }
        if (labels2 != null) {
            this.labels.addAll(Arrays.asList(labels2));
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor mv) {
        int[] keys = new int[this.keys.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.keys.get(i);
        }
        Label[] labels2 = new Label[this.labels.size()];
        for (int i = 0; i < labels2.length; ++i) {
            labels2[i] = this.labels.get(i).getLabel();
        }
        mv.visitLookupSwitchInsn(this.dflt.getLabel(), keys, labels2);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels2) {
        LookupSwitchInsnNode clone2 = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, labels2), null, LookupSwitchInsnNode.clone(this.labels, labels2));
        clone2.keys.addAll(this.keys);
        return clone2;
    }
}

